/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@MCVersionDependentBehaviour
public final class SFMRegistryWrapper<T>
implements Iterable<T> {
    private final ResourceKey<? extends Registry<T>> registryKey;
    @MCVersionDependentBehaviour
    @Nullable
    private Registry<T> maybeInner;

    public SFMRegistryWrapper(@MCVersionDependentBehaviour Registry<T> inner) {
        this.maybeInner = inner;
        this.registryKey = inner.key();
    }

    public SFMRegistryWrapper(ResourceKey<? extends Registry<T>> registryKey) {
        this.maybeInner = null;
        this.registryKey = registryKey;
    }

    @MCVersionDependentBehaviour
    @Nullable
    public T get(ResourceLocation resourceTypeId) {
        return (T)this.getInnerRegistry().get(resourceTypeId);
    }

    @MCVersionDependentBehaviour
    public Set<ResourceLocation> keys() {
        return this.getInnerRegistry().keySet();
    }

    public Iterable<T> values() {
        return this.getInnerRegistry();
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.getInnerRegistry().spliterator(), false);
    }

    public Stream<Holder.Reference<T>> holders() {
        Registry<T> registry = this.getInnerRegistry();
        if (registry instanceof MappedRegistry) {
            MappedRegistry mappedRegistry = (MappedRegistry)registry;
            return mappedRegistry.holders();
        }
        return Stream.empty();
    }

    @Nullable
    public ResourceLocation getId(T value) {
        return this.getInnerRegistry().getKey(value);
    }

    public Optional<ResourceKey<T>> getKey(T value) {
        return this.getInnerRegistry().getResourceKey(value);
    }

    @MCVersionDependentBehaviour
    public Set<Map.Entry<ResourceKey<T>, T>> entries() {
        return this.getInnerRegistry().entrySet();
    }

    @Override
    public Iterator<T> iterator() {
        return this.getInnerRegistry().iterator();
    }

    public ResourceKey<? extends Registry<T>> registryKey() {
        return this.registryKey;
    }

    public boolean contains(ResourceLocation location) {
        return this.getInnerRegistry().containsKey(location);
    }

    @MCVersionDependentBehaviour
    public Registry<T> getInnerRegistry() {
        if (this.maybeInner != null) {
            return this.maybeInner;
        }
        this.maybeInner = (Registry)BuiltInRegistries.REGISTRY.get(this.registryKey);
        if (this.maybeInner != null) {
            return this.maybeInner;
        }
        if (!SFMEnvironmentUtils.isClient()) {
            throw new IllegalStateException("Failed to acquire registry " + String.valueOf(this.registryKey) + " - not present in the registry registry, and we aren't on the client");
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            throw new IllegalStateException("Failed to acquire registry " + String.valueOf(this.registryKey) + " - client level is null?");
        }
        this.maybeInner = level.registryAccess().registryOrThrow(this.registryKey);
        return this.maybeInner;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SFMRegistryWrapper that = (SFMRegistryWrapper)obj;
        return Objects.equals(this.getInnerRegistry(), that.getInnerRegistry());
    }

    public int hashCode() {
        return Objects.hash(this.getInnerRegistry());
    }

    public String toString() {
        return "SFMRegistryWrapper[inner=" + String.valueOf(this.maybeInner) + "]";
    }

    public HolderLookup.RegistryLookup<T> asHolderLookup() {
        return this.getInnerRegistry().asLookup();
    }
}

